import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart' as googlefonts;
import 'package:wordpress_app/config/config.dart';

class ThemeModel {
  // LIGHT MODE
  final lightTheme = ThemeData(
    useMaterial3: true,
    visualDensity: VisualDensity.adaptivePlatformDensity,
    primaryColor: Config.appThemeColor,
    fontFamily: googlefonts.GoogleFonts.getFont('Poppins').fontFamily,
    colorScheme: ColorScheme.fromSeed(
      seedColor: Config.appThemeColor,
      brightness: Brightness.light,
    ),
    appBarTheme: const AppBarTheme(
      elevation: 0,
      centerTitle: false,
      systemOverlayStyle: SystemUiOverlayStyle.dark,
    ),
    bottomNavigationBarTheme: const BottomNavigationBarThemeData(
      selectedItemColor: Config.appThemeColor,
    ),
    dividerTheme: DividerThemeData(
      color: Colors.grey.shade300,
      thickness: 1,
    ),
  );

  // DARK MODE
  final darkTheme = ThemeData(
    useMaterial3: true,
    visualDensity: VisualDensity.adaptivePlatformDensity,
    fontFamily: googlefonts.GoogleFonts.getFont('Poppins').fontFamily,
    colorScheme: ColorScheme.fromSeed(
      seedColor: Config.appThemeColor,
      brightness: Brightness.dark,
    ),
    primaryColor: Config.appThemeColor,
    appBarTheme: const AppBarTheme(
      elevation: 0,
      centerTitle: false,
      titleTextStyle: TextStyle(
        fontSize: 18,
        fontWeight: FontWeight.w600,
      ),
      systemOverlayStyle: SystemUiOverlayStyle.light,
    ),
    bottomNavigationBarTheme: const BottomNavigationBarThemeData(
      backgroundColor: Colors.black,
      selectedItemColor: Config.appThemeColor,
      unselectedItemColor: Colors.white,
    ),
  );
}
